/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentHelper;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItem;
import java.util.Vector;

class VWAttachmentTableRowItem {
    private Vector m_rowData = null;
    private boolean m_bExpanded = true;
    private VWIDMItem m_unexpandedItem = null;
    private VWParameter m_vwParameter = null;

    public VWAttachmentTableRowItem(VWParameter vwParameter) {
        this.initData(vwParameter);
    }

    public VWIDMItem getItemAt(int nIndex) {
        VWIDMItem rowItem = null;
        if (this.m_rowData == null || nIndex < 0 || nIndex > this.m_rowData.size()) {
            return null;
        }
        if (nIndex < this.m_rowData.size()) {
            if (this.isExpandable() && !this.isExpanded() && this.m_unexpandedItem != null) {
                return this.m_unexpandedItem;
            }
            rowItem = (VWIDMItem)this.m_rowData.elementAt(nIndex);
        }
        return rowItem;
    }

    public VWParameter getParameter() {
        return this.m_vwParameter;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public boolean isExpandable() {
        return this.m_rowData != null && this.getRowCount() > 1;
    }

    public boolean isExpanded() {
        if (this.isExpandable()) {
            return this.m_bExpanded;
        }
        return false;
    }

    public void setExpanded(boolean bExpanded) {
        this.m_bExpanded = this.isExpandable() ? bExpanded : false;
    }

    public void addAttachment(VWAttachment newAttachment, VWStepElement stepElement) {
        try {
            VWIDMItem idmItem;
            if (this.m_vwParameter == null || stepElement == null) {
                return;
            }
            if (!this.m_vwParameter.isArray()) {
                return;
            }
            if (newAttachment == null) {
                newAttachment = new VWAttachment();
            }
            if ((idmItem = new VWIDMItem(this, newAttachment, this.m_rowData.size())) != null) {
                this.m_rowData.addElement(idmItem);
                VWAttachmentHelper vwAttachmentHelper = idmItem.getAttachmentHelper();
                if (vwAttachmentHelper != null) {
                    vwAttachmentHelper.updateCheckoutStatus();
                }
                VWAttachment[] attachmentArray = new VWAttachment[this.m_rowData.size()];
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    idmItem = (VWIDMItem)this.m_rowData.elementAt(i);
                    if (idmItem == null) continue;
                    attachmentArray[i] = idmItem.getAttachment();
                }
                stepElement.setParameterValue(this.m_vwParameter.getName(), attachmentArray, false);
                this.m_vwParameter.setValue((VWAttachment[])stepElement.getParameterValue(this.m_vwParameter.getName()));
                this.updateAttachmentNames();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean deleteAttachment(int nArrayIndex, VWStepElement stepElement) {
        try {
            if (this.m_vwParameter == null || stepElement == null) {
                return false;
            }
            if (!this.m_vwParameter.isArray() || this.isAttachmentArrayEmpty()) {
                return false;
            }
            if (nArrayIndex < 0 || nArrayIndex > this.m_rowData.size()) {
                return false;
            }
            this.m_rowData.removeElementAt(nArrayIndex);
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                VWIDMItem idmItem = (VWIDMItem)this.m_rowData.elementAt(i);
                if (idmItem == null) continue;
                idmItem.setArrayIndex(i);
            }
            if (this.m_rowData.isEmpty()) {
                this.m_rowData.addElement(new VWIDMItem(this, new VWAttachment(), 0));
            }
            VWAttachment[] attachmentArray = new VWAttachment[this.m_rowData.size()];
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                VWIDMItem idmItem = (VWIDMItem)this.m_rowData.elementAt(i);
                if (idmItem == null) continue;
                attachmentArray[i] = idmItem.getAttachment();
            }
            stepElement.setParameterValue(this.m_vwParameter.getName(), attachmentArray, false);
            this.m_vwParameter.setValue((VWAttachment[])stepElement.getParameterValue(this.m_vwParameter.getName()));
            this.updateAttachmentNames();
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public void updateAttachment(int nArrayIndex, VWAttachment newAttachment, VWStepElement stepElement) {
        try {
            VWIDMItem idmItem;
            if (this.m_vwParameter == null || stepElement == null) {
                return;
            }
            if (nArrayIndex < 0 || nArrayIndex > this.m_rowData.size()) {
                return;
            }
            if (newAttachment == null) {
                newAttachment = new VWAttachment();
            }
            if ((idmItem = (VWIDMItem)this.m_rowData.elementAt(nArrayIndex)) != null) {
                idmItem.setAttachment(newAttachment);
                if (this.m_vwParameter.isArray()) {
                    VWAttachment[] attachmentArray = new VWAttachment[this.m_rowData.size()];
                    for (int i = 0; i < this.m_rowData.size(); ++i) {
                        idmItem = (VWIDMItem)this.m_rowData.elementAt(i);
                        if (idmItem == null) continue;
                        attachmentArray[i] = idmItem.getAttachment();
                    }
                    stepElement.setParameterValue(this.m_vwParameter.getName(), attachmentArray, false);
                    this.m_vwParameter.setValue((VWAttachment[])stepElement.getParameterValue(this.m_vwParameter.getName()));
                } else {
                    stepElement.setParameterValue(this.m_vwParameter.getName(), newAttachment, true);
                    this.m_vwParameter.setValue((VWAttachment)stepElement.getParameterValue(this.m_vwParameter.getName()));
                }
                this.updateAttachmentNames();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isAttachmentArrayEmpty() {
        block6: {
            try {
                if (this.m_vwParameter == null || !this.m_vwParameter.isArray()) break block6;
                VWAttachment[] attachmentArray = null;
                try {
                    attachmentArray = (VWAttachment[])this.m_vwParameter.getValue();
                }
                catch (Exception ex) {
                    attachmentArray = null;
                    VWDebug.logException(ex);
                }
                if (attachmentArray == null) {
                    return true;
                }
                if (attachmentArray.length == 1 && (attachmentArray[0].getType() == 5 ? attachmentArray[0].getId() == null : attachmentArray[0].getAttachmentName() == null)) {
                    return true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return false;
    }

    private void initData(VWParameter vwParameter) {
        try {
            this.m_vwParameter = vwParameter;
            this.m_rowData = new Vector();
            if (vwParameter != null) {
                if (vwParameter.isArray()) {
                    VWAttachment[] vwAttachments = (VWAttachment[])vwParameter.getValue();
                    if (vwAttachments == null) {
                        vwAttachments = new VWAttachment[]{new VWAttachment()};
                    }
                    for (int i = 0; i < vwAttachments.length; ++i) {
                        this.m_rowData.addElement(new VWIDMItem(this, vwAttachments[i], i));
                    }
                    this.updateAttachmentNames();
                } else {
                    this.m_rowData.addElement(new VWIDMItem(this, (VWAttachment)vwParameter.getValue()));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateAttachmentNames() {
        try {
            if (this.isExpandable()) {
                StringBuffer nameBuffer = new StringBuffer();
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    VWIDMItem item = (VWIDMItem)this.m_rowData.elementAt(i);
                    if (item == null || item.getAttachment() == null) continue;
                    String attName = null;
                    attName = item.getAttachment().getType() == 5 ? item.getAttachment().getId() : item.getAttachment().getAttachmentName();
                    if (attName == null) continue;
                    if (i > 0) {
                        nameBuffer.append(";");
                    }
                    nameBuffer.append(attName);
                }
                if (this.m_unexpandedItem != null) {
                    this.m_unexpandedItem.setAttachmentNames(nameBuffer.toString());
                } else {
                    this.m_unexpandedItem = new VWIDMItem(this, nameBuffer.toString());
                }
            } else {
                this.m_unexpandedItem = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

